<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Entreprise extends Model 
{

    protected $table = 'entreprises';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_NMadmin', 'slug', 'name', 'logo', 'logo2', 'favicon', 'defaultTheme', 'notificationSeuilStock', 'sante_type_depense', 'achat_aliment_type_depense', 'caisseTotal', 'dateFin', 'nombreUtilisateur', 'nombreVague', 'statut');
    protected $visible = array('id_NMadmin', 'slug', 'name', 'logo', 'logo2', 'favicon', 'defaultTheme', 'notificationSeuilStock', 'sante_type_depense', 'achat_aliment_type_depense', 'caisseTotal', 'dateFin', 'nombreUtilisateur', 'nombreVague', 'statut');

    public function utilisateur()
    {
        return $this->hasMany('App\Models\Utilisateur', 'id_entreprise');
    }

    public function utilisateurNiveau4()
    {
        return $this->hasMany('App\Models\UtilisateurNiveau4', 'id_entreprise');
    }

    public function espece()
    {
        return $this->hasMany('App\Models\Espece', 'id_entreprise');
    }

    public function depenses()
    {
        return $this->hasMany('App\Models\Depense', 'id_entreprise');
    }

    public function montantTypeCaisse()
    {
        return $this->hasMany('App\Models\MontantTypeCaisse', 'id_entreprise');
    }

    public function mailSms()
    {
        return $this->hasMany('App\Models\MailSms', 'id_entreprise');
    }

    public function NMadmin()
    {
        return $this->belongsTo('App\Models\NMadmin', 'id_NMadmin');
    }

    public function motifDepense()
    {
        return $this->hasMany('App\Models\MotifDepense', 'id_entreprise');
    }

    public function unite()
    {
        return $this->hasMany('App\Models\Unite', 'id_entreprise');
    }

    public function versement()
    {
        return $this->hasMany('App\Models\Versement', 'id_entreprise');
    }

}